/*
This raindrop code was taken from https://www.shadertoy.com/view/ltffzl
(by Martijn Steinrucken aka BigWings) and modified by LexBoosT & ShinoNeiluj
*/

#if (!defined RAINDROP_ON_SCREEN || ! defined OVERWORLD)
vec2 raindropRefraction(vec2 coord) {
	return coord;
}
#endif

#if (defined OVERWORLD && defined RAINDROP_ON_SCREEN)

float rainSmooth = biomeHasNoRain;
float notColdSmooth = biomeHasNoSnow;

float dropSpeed = frameTimeCounter * DROP_SPEED;

vec3 N13(float p) {

	vec3 p3 = fract(vec3(p) * vec3(0.1031, 0.11369, 0.13787));
	p3 += dot(p3, p3.yzx + 19.19);
	return fract(vec3((p3.x + p3.y) * p3.z, (p3.x + p3.z) * p3.y, (p3.y + p3.z) * p3.x));
}

vec4 N14(float t) {
	return fract(sin(t * vec4(123.0, 1024.0, 1456.0, 264.0)) * vec4(6547.0, 345.0, 8799.0, 1564.0));
}
float N(float t) {
	return fract(sin(t * 12345.564) * 7658.76);
}

float Saw(float b, float t) {
	return smoothstep(0.0, b, t) * smoothstep(1.0, b, t);
}

vec2 DropLayer2(vec2 uv, float t) {
	vec2 UV = uv;

	uv.y += t * 0.75;
	vec2 a = vec2(6.0, 1.0);
	vec2 grid = a * 2.0;
	vec2 id = floor(uv * grid);

	float colShift = N(id.x);
	uv.y += colShift;

	id = floor(uv * grid);
	vec3 n = N13(id.x * 35.2 + id.y * 2376.1);
	vec2 st = fract(uv * grid) - vec2(0.5, 0.0);

	float x = n.x - 0.5;

	float y = UV.y * 20.0;
	float wiggle = sin(y + sin(y));
	x += wiggle * (0.5 - abs(x)) * (n.z - 0.5);
	x *= 0.7;
	float ti = fract(t + n.z);
	y = (Saw(0.85, ti) - 0.5) * 0.9 + 0.5;
	vec2 p = vec2(x, y);

	float d = length((st - p) * a.yx);

	float mainDrop = smoothstep(0.4, 0.0, d);

	float r = sqrt(smoothstep(1.0, y, st.y));
	float cd = abs(st.x - x);
	float trail = smoothstep(0.13 * r, 0.15 * r * r, cd);
	float trailFront = smoothstep(- 0.02, 0.02, st.y - y);
	trail *= trailFront * r * r;

	y = UV.y;
	float trail2 = smoothstep(0.2 * r, 0.0, cd);
	float droplets = max(0.0, (sin(y * (1.0 - y) * 120.0) - st.y)) * trail2 * trailFront * n.z;
	y = fract(y * 10.0) + (st.y - 0.5);
	float dd = length(st - vec2(x, y));
	droplets = smoothstep(0.3, 0.0, dd);
	float m = mainDrop + droplets * r * trailFront;

	return vec2(m, trail);
}

float StaticDrops(vec2 uv, float t) {
	uv *= 40.0;

	vec2 id = floor(uv);
	uv = fract(uv) - 0.5;
	vec3 n = N13(id.x * 107.45 + id.y * 3543.654);
	vec2 p = (n.xy - 0.5) * 0.7;
	float d = length(uv - p);

	float fade = Saw(0.025, fract(t + n.z));
	float c = smoothstep(0.3, 0.0, d) * fract(n.z * 10.0) * fade;
	return c;
}

vec2 Drops(vec2 uv, float t, float l0, float l1, float l2) {

	float s = StaticDrops(uv, t) * l0;
	vec2 m1 = DropLayer2(uv, t) * l1;
	vec2 m2 = DropLayer2(uv * 1.85, t) * l2;

	float c = s + m1.x + m2.x;
	c = smoothstep(0.3, 1.0, c);

	return vec2(c, max(m1.y * l0, m2.y * l1));
}

vec2 raindropRefraction(vec2 coord) {

	#ifndef RAINDROPS_IN_COLD
	rainSmooth *= notColdSmooth;
	#endif

	float rainVisibility = eBS2;
	rainVisibility *= rainSmooth;
	rainVisibility *= rainFactor;
	if (rainVisibility < 0.1)
	rainVisibility = 0.0;
	if (rainVisibility > 0.0 && isEyeInWater == 0) {

		float rainAmount0 = rainVisibility * STATIC_DROP;
		float rainAmount1 = rainVisibility * DROP_LAYER_1;
		float rainAmount2 = rainVisibility * DROP_LAYER_2;

		vec2 uv = (coord - vec2(0.5)) * vec2(aspectRatio, 1.0);
		float t = dropSpeed;
		float staticDrops = smoothstep(- 0.5, 1.0, rainAmount0) * 2.0;
		float layer1 = smoothstep(0.25, 0.75, rainAmount1);
		float layer2 = smoothstep(0.0, 0.5, rainAmount2);

		vec2 c = Drops(uv, t, staticDrops, layer1, layer2);

		vec2 e = vec2(0.001, 0.0);
		float cx = Drops(uv + e, t, staticDrops, layer1, layer2).x;
		float cy = Drops(uv + e.yx, t, staticDrops, layer1, layer2).x;
		vec2 n = vec2(cx - c.x, cy - c.x);

		return coord + n;

	} else {

		return coord;

	}
}

#endif
